/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.HorseColors;
import sekelsta.horse_colors.client.GeneBookScreen;
import sekelsta.horse_colors.entity.ModEntities;
import sekelsta.horse_colors.entity.genetics.EquineGenome;
import sekelsta.horse_colors.entity.genetics.Genome;
import sekelsta.horse_colors.entity.genetics.Species;

public class GeneBookItem
extends Item {
    public GeneBookItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean validBookTagContents(CompoundNBT nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_150297_b("species", 8)) {
            return false;
        }
        if (!nbt.func_150297_b("genes", 8)) {
            return false;
        }
        try {
            Species species = Species.valueOf(nbt.func_74779_i("species"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static Species getSpecies(CompoundNBT compoundnbt) {
        String s = compoundnbt.func_74779_i("species");
        if (!StringUtils.func_151246_b((String)s)) {
            return Species.valueOf(s);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt;
        Species species;
        if (stack.func_77942_o() && (species = GeneBookItem.getSpecies(compoundnbt = stack.func_77978_p())) != null) {
            String translation = null;
            switch (species) {
                case HORSE: {
                    translation = ModEntities.HORSE_GENETIC.func_210760_d();
                    break;
                }
                case DONKEY: {
                    translation = ModEntities.DONKEY_GENETIC.func_210760_d();
                    break;
                }
                case MULE: {
                    translation = ModEntities.MULE_GENETIC.func_210760_d();
                }
            }
            if (translation != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent(translation).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (GeneBookItem.validBookTagContents(itemstack.func_77978_p())) {
            if (worldIn.func_201670_d()) {
                this.openGeneBook(itemstack.func_77978_p());
            }
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        HorseColors.logger.error("Gene book has invalid NBT");
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (stack.func_77978_p() == null) {
            HorseColors.logger.error("Gene book has no NBT data");
            return ActionResultType.FAIL;
        }
        if (!stack.func_77978_p().func_186855_b("EntityUUID")) {
            return ActionResultType.PASS;
        }
        UUID entityUUID = stack.func_77978_p().func_186857_a("EntityUUID");
        if (entityUUID == null) {
            return ActionResultType.PASS;
        }
        if (!entityUUID.equals(target.func_110124_au())) {
            return ActionResultType.PASS;
        }
        if (target.func_145818_k_()) {
            stack.func_200302_a(target.func_200201_e());
        } else {
            stack.func_135074_t();
        }
        return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openGeneBook(CompoundNBT nbt) {
        Minecraft mc = Minecraft.func_71410_x();
        EquineGenome genome = new EquineGenome(GeneBookItem.getSpecies(nbt));
        ((Genome)genome).genesFromString(nbt.func_74779_i("genes"));
        mc.func_147108_a((Screen)new GeneBookScreen(genome));
    }
}

